/**************************************************************************

Copyright (c) 2020 - 2021, Intel Corporation. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/
#include "Hii/Hii.h"
#include "Hii/FormsetStd/HiiCommonDep.h"
#include "Hii/CfgAccessProt/HiiConfigAccessInfo.h"
#include "HiiConfigData.h"

/** Instatiates first 2 fields (offset, width) in HII_CONFIG_MAP_ENTRY structure.

  @param[in]  Field   Name of the field in structure
**/
#if DBG_LVL & HII
  #define OFFSET_WIDTH(Field) \
    STRUCT_OFFSET (HII_STD_VARSTORE, Field), sizeof (((HII_STD_VARSTORE *) 0)->Field), .Name = "" #Field ""
#else /* !(DBG_LVL & HII) */
  #define OFFSET_WIDTH(Field) \
    STRUCT_OFFSET (HII_STD_VARSTORE, Field), sizeof (((HII_STD_VARSTORE *) 0)->Field)
#endif /* DBG_LVL & HII */
HII_CONFIG_MAP_ENTRY  mHiiConfigMap[] = {
  /*                                                                                                | Last 3 fields are relevant ONLY when runtime evaluation is needed, if parameter |
                                                                                                    | visibility is hardcoded in VFR e.g. "grayoutif TRUE", determined by other       |
                                                                                                    | known values, or not needed, then mark it as VIS_NO_EVAL.                       |
   | 2 fields (offset + width)                | Getter (ExtractConfig)   | Setter (RouteConfig)     | SupportTable idx | Is Modifiable ?       | Is Supported ?          |*/

  // --------------------------- <"NIC Configuration"> menu -------------------------------------
  { OFFSET_WIDTH (LinkSpeed),                  GetLinkSpeed,              SetLinkSpeed,              LINK_SPEED,        IsLinkSpeedModifiable, IsLinkSpeedSupported },
  { OFFSET_WIDTH (WolStatus),                  WolGetWakeOnLanStatus,     WolSetWakeOnLanStatus,     VIS_NO_EVAL,       NULL,                  NULL },
  { OFFSET_WIDTH (DefaultWolStatus),           GetDefaultWolStatus,       NULL,                      VIS_NO_EVAL,       NULL,                  NULL },
  { OFFSET_WIDTH (LldpAgentStatus),            GetLldpAgentStatus,        SetLldpAgentStatus,        LLDP_AGENT,        NULL,                  IsLldpAgentSupported },
  { OFFSET_WIDTH (DefaultLldpAgentStatus),     GetDfltLldpAgentStatus,    NULL,                      LLDP_AGENT,        NULL,                  IsLldpAgentSupported },




  // ---------------------------  Main HII menu -----------------------------------------------
  { OFFSET_WIDTH (BlinkLed),                   NULL,                      BlinkLeds,                 VIS_NO_EVAL,       NULL,                  NULL },
  { OFFSET_WIDTH (LinkStatus),                 GetLinkStatus,             NULL,                      VIS_NO_EVAL,       NULL,                  NULL },
  { OFFSET_WIDTH (AltMacAddr),                 GetAltMacAddr,             NULL,                      ALT_MAC,           NULL,                  IsAltMacAddrSupported },
  // special SupportTable field treated differently in ExtractConfig
  { OFFSET_WIDTH (Support),                    NULL,                      NULL,                      VIS_NO_EVAL,       NULL,                  NULL }
};

HII_VARSTORE_MAP_CFG  mHiiStandardMapCfg = {

  .ConfigMap               = mHiiConfigMap,
  .NumMapEntries           = sizeof (mHiiConfigMap) / sizeof (mHiiConfigMap[0]),
  .ConfigName              = L"NicCfgData",
  .ConfigGuid              = HII_DATA_GUID,
  .ConfigSize              = sizeof (HII_STD_VARSTORE),
  .HasSupportTable         = TRUE,
  .SupportTableOffset      = OFFSET_OF (HII_STD_VARSTORE, Support),
  .PreRoute                = HiiConfigMapPreRoute,
  .PostRoute               = HiiConfigMapPostRoute,
  .EvalUnaffiliatedSupport = EvaluateUnaffiliatedSupportFlags
};

/** Performs operations before starting varstore config map processing for standard formset RouteConfig().

   @param[in]   UndiPrivateData  Pointer to driver private data structure
   @param[in]   HiiCfgData       Pointer to raw configuration data buffer (of varstore type)
   @param[in]   Configuration    RouteConfig Configuration string

   @retval      EFI_SUCCESS      Operation successful
   @retval      !EFI_SUCCESS     Failure with reason specific to adapter
**/
EFI_STATUS
HiiConfigMapPreRoute (
  IN       UNDI_PRIVATE_DATA  *UndiPrivateData,
  IN       HII_STD_VARSTORE   *HiiCfgData,
  IN CONST EFI_STRING         Configuration
  )
{
  return EFI_SUCCESS;
}

/** Performs operations after varstore config map processing is finished for standard formset RouteConfig().

   @param[in]   UndiPrivateData  Pointer to driver private data structure

   @retval      EFI_SUCCESS      Operation successful
   @retval      !EFI_SUCCESS     NVM checksum update failed
   @retval      !EFI_SUCCESS     Failure with reason specific to adapter
**/
EFI_STATUS
HiiConfigMapPostRoute (
  IN UNDI_PRIVATE_DATA *UndiPrivateData
  )
{
  EFI_STATUS Status;

  Status = UpdateNvmChecksum (UndiPrivateData);
  IF_RETURN (EFI_ERROR (Status), Status);


  DEBUGPRINT (HII, ("RouteConfig changes commited\n"));
  return EFI_SUCCESS;
}
